<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\backend\PageController;
use App\Http\Controllers\backend\AdminController;
use App\Http\Controllers\frontend\HomeController;
use App\Http\Controllers\frontend\AboutController;
use App\Http\Controllers\backend\ProjectController;
use App\Http\Controllers\backend\ServiceController;
use App\Http\Controllers\backend\CategoryController;
use App\Http\Controllers\frontend\ContactController;
use App\Http\Controllers\frontend\ProjectsController;
use App\Http\Controllers\frontend\ServicesController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('services', [ServicesController::class, 'index'])->name('services');
// Route::get('services/all', [ServicesController::class, 'serviceHome'])->name('services.home'); 
Route::get('services/all', [ServicesController::class, 'serviceAll']);
Route::get('services/{service:slug}', [ServicesController::class, 'detail'])->name('detail');
Route::get('projects', [ProjectsController::class, 'index'])->name('projects');
Route::get('about', [AboutController::class, 'index'])->name('about');
Route::get('contact', [ContactController::class, 'index'])->name('contact');

Route::prefix('admin')->middleware(['auth'])->group(function(){
    Route::get('/', [PageController::class, 'home'])->name('admin.home');
    Route::resource('admin-account', AdminController::class);
    Route::resource('category', CategoryController::class);
    Route::resource('service', ServiceController::class);
    Route::resource('project', ProjectController::class);
});

Auth::routes();
