<?php

namespace App\Models;

use App\Models\Category;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Service extends Model
{
    use HasFactory;
    protected $guarded = [ ];
    public function setTitleAttribute($value)
    {
        $this->attributes['title'] = $value;
        $this->attributes['slug'] = strtolower(Str::slug($value));
    }
    public function Category()
    { 
        return $this->belongsToMany(Category::class);
    }
    public function scopeFilter(Builder $builder, array $filters)
    {   
        // dd($filters);
       
            $builder = $builder->when($filters['category_id'] ?? false, function ($query){
             $query->whereIn('id', function($query){
                              $query->select('service_id')
                                         ->from('category_service')
                                          ->where('category_id', request('category_id'));
                      });
            });
      
       return $builder;
     }
}
