<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AdminRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' =>'required|string|min:3|max:20',
            'email' =>'required|email|unique:users,email',
            'phone' =>'required|unique:users,phone|numeric|digits:11',
            'password' => 'required|min:6|max:20',
            'gender' => 'required',
            'profile' => 'required',
        ];
    }
}
