<?php

namespace App\Http\Controllers\backend;

use Carbon\Carbon;
use App\Models\Project;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use App\Http\Controllers\Controller;
use App\Http\Requests\ProjectRequest;
use App\Http\Requests\ProjectUpdateRequest;

class ProjectController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->ajax()) {
            return $this->dataTable();
        }

        return view('backend.project.index');
    }
    private function dataTable()
    {
        $query = Project::query();
            return DataTables::of($query)
                       ->addColumn('action' , function($project)
                       {
                        return view('backend.action.project' , ['project' => $project]);

                       })
                       ->order(function ($project)
                       {
                        $project->orderBy('created_at' , 'desc');
                       })
                       ->addColumn('created_at' , function ($data)
                      {
                        return date('d-M-Y H:i:s' , strtotime($data->created_at));
                      })
                      ->addColumn('updated_at' , function ($data)
                      {
                        return Carbon::parse($data->updated_at)->format('d-M-Y H:i:s');
                      })
                      ->rawColumns(['action'])
                      ->make(true);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.project.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ProjectRequest $request)
    {
        $attributes = $request->validated();
        $images = [];
        if($request->hasFile('image')){
        foreach ($attributes['image'] as $image) {
            $file_name = uploadFile($image, 'images');
            array_push($images,$file_name);
         }
         $attributes['image'] = implode(',',$images);
        }
        Project::create($attributes);
        return redirect()->route('project.index')->with('success' , 'Project is successfully created!');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Project $project)
    {
        $project_images = explode(',', $project->image);
        return view('backend.project.show' , ['project_images' => $project_images,'project' => $project]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Project $project)
    {
        return view('backend.project.edit',['project' => $project]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(ProjectUpdateRequest $request, Project $project)
    {
        $attributes = $request->validated();
        $images = [];
        if($request->hasFile('image')){
        foreach ($attributes['image'] as $image) {
            $file_name = uploadFile($image, 'images');
            array_push($images,$file_name);
         }
         $attributes['image'] = implode(',',$images);
        }
        $project->update($attributes);
        return redirect()->route('project.index')->with('success' , 'Project is successfully updated!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Project $project)
    {
        $project->delete();
        return 'success';
    }
}
